﻿//////////////////////////////////////////////
// ToneMappingEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkGraphics
{
	class Program ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

#include "../Effect.h"

#include "ToneMappingEffectInfo.h"
#include "ToneMappingHablesCurveDescriptor.h"

// nkMaths
#include <NilkinsMaths/Algebra/Matrix.h>
#include <NilkinsMaths/Algebra/Vector.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT ToneMappingEffect final : public Effect
	{
		public :

			// Constructor, destructor
			ToneMappingEffect (System* system) noexcept ;
			virtual ~ToneMappingEffect () ;

			// Getters
			nkGraphics::Texture* getSourceTexture () const ;
			bool getReinhardUsed () const ;
			const nkMaths::Vector& getReinhardMaxWhite () const ;
			bool getHablesUsed () const ;
			const ToneMappingHablesCurveDescriptor& getHablesDescriptor () const ;
			bool getAcesUsed () const ;
			const nkMaths::Matrix& getAcesLookTransform () const ;

			// Setters
			void setSourceTexture (nkGraphics::Texture* value) ;
			void setAsReinhard (const nkMaths::Vector& maxWhite = nkMaths::Vector(2.f, 2.f, 2.f)) ;
			void setAsHables (const ToneMappingHablesCurveDescriptor& descriptor = ToneMappingHablesCurveDescriptor()) ;
			void setAsAces (const nkMaths::Matrix& lookTransform = nkMaths::Matrix(1.f, 0.f, 0.f, 0.f, 1.f, 0.f, 0.f, 0.f, 1.f)) ;
			void setUseLuminance (bool value) ;

			// Load
			virtual bool load () override ;
			virtual void unload () override ;

		public :

			// Statics
			static nkMemory::UniquePtr<ToneMappingEffect> create (System* system = nullptr) ;

		private :

			// Functions
			// Program
			bool _prepareProgram () ;

			// Shader
			bool _prepareShader () ;

		private :

			// Attributes
			System* _system ;

			// Program
			nkGraphics::Program* _program ;
			ToneMappingEffectInfo _programInfo ;

			// Info
			ToneMappingEffectInfo _info ;

			// Bonus info
			// Reinhard
			nkMaths::Vector _reinhardMaxWhite ;
			// Hables
			ToneMappingHablesCurveDescriptor _hablesDescriptor ;
			// ACES
			nkMaths::Matrix _acesLookTransform ;
	} ;
}